//Error rate performance of QPSK modulated signal over only AWGN channel and AWGN and Rayleigh channel both
clc;
clear;
xdel(winsid());
sym=10000;//No .of symbols
M=4;
qpsk_mod=[];i_phase=[];
data1=grand(1,sym,"uin",0,1);//Random Symbol generation from 0 to 1 with uniform distribution
for j=1:2:length(data1)// Seperation of I & Q component
   i_phase=2*data1(j)-1;// BPSK modulation of I phase component
   q_phase=2*data1(j+1)-1;//BPSK modulation of Q phase component
   temp=i_phase+%i*q_phase;//combining of I phase and Q phase component for QPSK modulation
   qpsk_mod=[qpsk_mod temp];//QPSK modulated signal
 end

   snr=1:5:41;//Signal to Noise Ratio
    for k=1:length(snr)
        H=1/sqrt(2)*(rand(1,length(qpsk_mod),'normal')+%i*(rand(1,length(qpsk_mod),'normal')));//Rayleigh fading generation
       
        noise1=1/sqrt(2)*(10^(-(k/20)))*(rand(1,length(qpsk_mod),'normal')+%i*(rand(1,length(qpsk_mod),'normal')));//White Gaussian Noise generation for QPSK
        
               rec1_qpsk=qpsk_mod+noise1;//QPSK modulated signal over AWGN channel
                rec1_qpsk_ray1= H.*qpsk_mod+noise1;//BPSK modulated signal over AWGN channel and Rayleigh Fading channel
               rec1_qpsk_ray=conj(H).*rec1_qpsk_ray1;//multiplication with conjugate of rayleigh fading to nullify phase because of Rayleigh Fading
                            
               rec_data_qpsk=[];rec_data_qpsk_ray=[];
              
               rec1_i=real(rec1_qpsk);//Seperation of I phase and Q phase comopnent of received QPSK modulated signal
               rec1_q=imag(rec1_qpsk);
               
                rec1_i_ray=real(rec1_qpsk_ray);//Seperation of I phase and Q phase comopnent of received QPSK modulated signal
               rec1_q_ray=imag(rec1_qpsk_ray);
        //
        for i=1:length(rec1_i)//QPSK Demodulation: BPSK demodulation of I phase and Q phase components
            if rec1_i(i)>=0 
                 demod_out_i=1;
            else rec1_i(i)<0
                demod_out_i=0;                
            end
              if rec1_q(i)>=0 
                 demod_out_q=1;
            else rec1_q(i)<0
                demod_out_q=0;  
             end   
                if rec1_i_ray(i)>=0 
                 demod_out_i_ray=1;
            else rec1_i(i)<0
                demod_out_i_ray=0;                
            end            
              if rec1_q_ray(i)>=0 
                 demod_out_q_ray=1;
            else rec1_q_ray(i)<0
                demod_out_q_ray=0;            
            end
           rec_data_qpsk=[rec_data_qpsk demod_out_i demod_out_q];//QPSK Demodulated signal
           rec_data_qpsk_ray=[rec_data_qpsk_ray demod_out_i_ray demod_out_q_ray];//QPSK Demodulated signal
            end
                
        errA=0;errB=0;
    for i=1:sym
        if rec_data_qpsk(i)==data1(i)
            errA=errA;
        else
            errA=errA+1;
        end
    end
        BER_qpsk(k)=errA/sym;// BER of QPSK
       
         for i=1:sym
        if rec_data_qpsk_ray(i)==data1(i)
            errB=errB;
        else
            errB=errB+1;
        end
    
        BER_qpsk_ray(k)=errB/sym;//BER of BPSK
    end
    //theoryBer = 0.5*erfc(sqrt(10.^(snr/10))); //Theoritical BER of BPSK & QPSK
  end
        
       // end
snr=1:5:41;
plot2d(snr,BER_qpsk,5,logflag="nl");//plot simulated BER of BPSK over AWGN channel
plot2d(snr,BER_qpsk_ray,2,logflag="nl");//plot simulated BER of QPSK over AWGN channel
//plot2d(snr,theoryBer,3,logflag="nl");//Plot theoritical BER of QPSK and BPSK over AWGN channel
mtlb_axis([0 40 10^-5 0.5]);//axis
xgrid(10);
xtitle( 'Bit Error Rate plot for QPSK over AWGN channel & AWGN and Rayleigh channel both', 'SNR', 'BER') ;//title of plot

legend(['BER_QPSK_AWGN';'BER_QPSK_AWGN & Rayleigh']);//legend
//This experiments results plot of bit error rate(BER) comparison of simulated QPSK over AWGN channel,simulated QPSK over AWGN channel and Rayleigh fading channel.
// It will take few minutes to get plots as 10000 bits are applied as an input to get better plots
